;; A simple program to display "Hello World". This program
;; will work with CP/M 2.1 and C/PM +


;; origin for CP/M programs
org &100
nolist
write"cpmex1.com"

;;---------------------------------------------------------
.bdos equ 5

;;---------------------------------------------------------
;; display message and then return back to the command-line

ld hl,message
call display_message
ret

;;---------------------------------------------------------
;; HL = pointer to null terminated message
.display_message
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
or a					;; end of message marker (0)?
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char

;;---------------------------------------------------------
;; put character to console
;;
;; A = ASCII character

.display_char
push hl
ld c,2			;; console output function id
ld e,a			;; ASCII character
call bdos		;; call BDOS to execute function
pop hl
ret

;;---------------------------------------------------------
;; the message to display

.message
defb "Hello World!",0


